 function generateOTP() {
            return Math.floor(Math.random() * 900000) + 100000; // Temporary client-side OTP; server will override
        }

        document.getElementById("otp").value = generateOTP();

        const form = document.getElementById("registerForm");
        const emailInput = document.getElementById("email");
        const passwordInput = document.getElementById("password");
        const confirmPasswordInput = document.getElementById("cpassword");
        const submitButton = document.getElementById("submit-btn");
        const emailError = document.getElementById("email-error");
        const passwordError = document.getElementById("password-error");
        const cpasswordError = document.getElementById("cpassword-error");
        const formMessage = document.getElementById("form-message");
        const passwordStrength = document.getElementById("password-strength");
        const emailValid = document.getElementById("email-valid");
        const passwordValid = document.getElementById("password-valid");
        const cpasswordValid = document.getElementById("cpassword-valid");

        function validateEmail(email) {
            const emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
            return emailRegex.test(email);
        }

        function validatePassword(password) {
            const minLength = password.length >= 8;
            const hasUpperCase = /[A-Z]/.test(password);
            const hasLowerCase = /[a-z]/.test(password);
            const hasNumber = /[0-9]/.test(password);
            const hasSpecial = /[!@#$%^&*(),.?":{}|<>]/.test(password);

            let strength = 0;
            if (minLength) strength++;
            if (hasUpperCase) strength++;
            if (hasLowerCase) strength++;
            if (hasNumber) strength++;
            if (hasSpecial) strength++;

            return {
                isValid: strength >= 4,
                strength: strength,
                message: strength === 0 ? '' :
                         strength <= 2 ? 'Weak password' :
                         strength === 3 ? 'Medium password' : 'Strong password',
                class: strength <= 2 ? 'weak' : strength === 3 ? 'medium' : 'strong'
            };
        }

        function validateForm() {
            let valid = true;
            emailError.textContent = '';
            passwordError.textContent = '';
            cpasswordError.textContent = '';
            formMessage.textContent = '';
            formMessage.className = 'form-message hidden';
            emailValid.style.display = 'none';
            passwordValid.style.display = 'none';
            cpasswordValid.style.display = 'none';
            emailInput.classList.remove('border-green-500');
            passwordInput.classList.remove('border-green-500');
            confirmPasswordInput.classList.remove('border-green-500');

            if (!validateEmail(emailInput.value)) {
                emailError.textContent = 'Please enter a valid email address.';
                valid = false;
            } else {
                emailValid.style.display = 'block';
                emailInput.classList.add('border-green-500');
            }

            const passwordCheck = validatePassword(passwordInput.value);
            if (!passwordCheck.isValid) {
                passwordError.textContent = 'Password must be at least 8 characters with uppercase, lowercase, number, and special character.';
                valid = false;
            } else {
                passwordValid.style.display = 'block';
                passwordInput.classList.add('border-green-500');
            }
            passwordStrength.textContent = passwordCheck.message;
            passwordStrength.className = `password-strength text-${passwordCheck.class === 'weak' ? 'red' : passwordCheck.class === 'medium' ? 'yellow' : 'green'}-600`;

            if (passwordInput.value !== confirmPasswordInput.value) {
                cpasswordError.textContent = 'Passwords do not match.';
                valid = false;
            } else if (passwordInput.value && passwordCheck.isValid) {
                cpasswordValid.style.display = 'block';
                confirmPasswordInput.classList.add('border-green-500');
            }

            submitButton.disabled = !valid;
            submitButton.classList.toggle('disabled', !valid);
        }

        emailInput.addEventListener('input', validateForm);
        passwordInput.addEventListener('input', validateForm);
        confirmPasswordInput.addEventListener('input', validateForm);

        document.querySelectorAll('.toggle-password').forEach(toggle => {
            toggle.addEventListener('click', () => {
                const targetId = toggle.getAttribute('data-target');
                const input = document.getElementById(targetId);
                const icon = toggle;
                const type = input.getAttribute('type') === 'password' ? 'text' : 'password';
                input.setAttribute('type', type);
                icon.classList.toggle('bx-show');
                icon.classList.toggle('bx-hide');
            });
        });

        form.addEventListener("submit", async (e) => {
            e.preventDefault();
            validateForm();

            if (!submitButton.disabled) {
                try {
                    submitButton.disabled = true;
                    submitButton.classList.add('loading');
                    submitButton.querySelector('.button-content').style.display = 'none';

                    const formData = new FormData(form);
                    const response = await fetch("../authentication/send.php", {
                        method: "POST",
                        body: formData,
                    });

                    if (!response.ok) {
                        throw new Error(`HTTP error: ${response.status} ${response.statusText}`);
                    }

                    const data = await response.json();

                    if (data.success) {
                        formMessage.className = 'form-message bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded-lg text-center';
                        formMessage.textContent = 'Registration successful! OTP sent to your email.';
                        setTimeout(() => {
                            window.location.href = `../authentication/verify.php?email=${encodeURIComponent(formData.get('email'))}`;
                        }, 2000);
                    } else {
                        formMessage.className = 'form-message bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded-lg text-center';
                        formMessage.textContent = data.message || 'Registration failed. Please try again.';
                        submitButton.disabled = false;
                        submitButton.classList.remove('loading');
                        submitButton.querySelector('.button-content').style.display = 'flex';
                    }
                } catch (error) {
                    console.error('Fetch error:', {
                        message: error.message,
                        stack: error.stack
                    });
                    formMessage.className = 'form-message bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded-lg text-center';
                    formMessage.textContent = `Registration error: ${error.message.includes('HTTP error') ? 'Server error. Please try again later.' : 'Network error. Please check your connection.'}`;
                    submitButton.disabled = false;
                    submitButton.classList.remove('loading');
                    submitButton.querySelector('.button-content').style.display = 'flex';
                }
            }
        });