  document.addEventListener('DOMContentLoaded', function() {
            // Initialize debug log visibility
            const debugLog = document.querySelector('.debug-log');
            if (debugLog?.textContent.trim()) {
                debugLog.style.display = 'block';
            }

            // Sidebar toggle functionality
            const sidebar = document.querySelector('.sidebar');
            const menuToggle = document.querySelector('.menu-toggle');
            const closeSidebar = document.querySelector('.close-sidebar');
            const mainContent = document.querySelector('.main-content');
            const isMobile = window.matchMedia('(max-width: 576px)').matches;

            function toggleSidebar() {
                const isActive = sidebar.classList.toggle('active');
                mainContent.classList.toggle('sidebar-active', isActive);
                menuToggle.setAttribute('aria-expanded', isActive);
            }

            function closeSidebarOnMobile() {
                if (window.matchMedia('(max-width: 576px)').matches) {
                    sidebar.classList.remove('active');
                    mainContent.classList.remove('sidebar-active');
                    menuToggle.setAttribute('aria-expanded', 'false');
                }A
            }

            menuToggle.addEventListener('click', toggleSidebar);
            closeSidebar.addEventListener('click', closeSidebarOnMobile);

            // Auto-close sidebar on navigation link click for mobile
            document.querySelectorAll('.sidebar a').forEach(link => {
                link.addEventListener('click', closeSidebarOnMobile);
            });

            // Show/hide other gender field
            const genderSelect = document.querySelector('#gender');
            const otherGenderGroup = document.querySelector('#other_gender_group');
            const otherGenderInput = document.querySelector('#other_gender');

            genderSelect.addEventListener('change', function() {
                if (this.value === 'Other') {
                    otherGenderGroup.style.display = 'block';
                    otherGenderInput.setAttribute('required', 'required');
                } else {
                    otherGenderGroup.style.display = 'none';
                    otherGenderInput.removeAttribute('required');
                }
            });

            // Photo preview functionality
            const profilePhotoInput = document.querySelector('#profile_photo');
            const profilePreview = document.querySelector('#profile_preview');
            const idPhotoInput = document.querySelector('#id_photo');
            const idPreview = document.querySelector('#id_preview');

            profilePhotoInput.addEventListener('change', function() {
                const file = this.files[0];
                if (file) {
                    const reader = new FileReader();
                    reader.onload = function(e) {
                        profilePreview.src = e.target.result;
                        profilePreview.classList.remove('photo-placeholder');
                        profilePreview.classList.add('photo-preview');
                    };
                    reader.readAsDataURL(file);
                }
            });

            idPhotoInput.addEventListener('change', function() {
                const file = this.files[0];
                if (file) {
                    const reader = new FileReader();
                    reader.onload = function(e) {
                        idPreview.src = e.target.result;
                        idPreview.classList.remove('photo-placeholder');
                        idPreview.classList.add('photo-preview');
                    };
                    reader.readAsDataURL(file);
                }
            });

            // Contact number formatting
            const contactInput = document.querySelector('#contact');
            contactInput.addEventListener('input', function() {
                this.value = this.value.replace(/[^0-9]/g, '').slice(0, 10);
            });

            // Close sidebar with Escape key
            document.addEventListener('keydown', function(e) {
                if (e.key === 'Escape' && isMobile && sidebar.classList.contains('active')) {
                    closeSidebarOnMobile();
                }
            });

            // Prevent back button issues
            window.addEventListener('pageshow', function(event) {
                if (event.persisted || (window.performance && window.performance.navigation.type === 2)) {
                    window.location.reload();
                }
            });

            // Close sidebar on initial load for mobile
            if (isMobile) {
                closeSidebarOnMobile();
            }
        });