document.addEventListener('DOMContentLoaded', function() {
            // Initialize debug log visibility
            const debugLog = document.querySelector('.debug-log');
            if (debugLog?.textContent.trim()) {
                debugLog.style.display = 'block';
            }

            // Sidebar toggle functionality
            const sidebar = document.querySelector('.sidebar');
            const menuToggle = document.querySelector('.menu-toggle');
            const closeSidebar = document.querySelector('.close-sidebar');
            const mainContent = document.querySelector('.main-content');
            const isMobile = window.matchMedia('(max-width: 576px)').matches;

            function toggleSidebar() {
                const isActive = sidebar.classList.toggle('active');
                mainContent.classList.toggle('sidebar-active', isActive);
                menuToggle.setAttribute('aria-expanded', isActive);
            }

            function closeSidebarOnMobile() {
                if (window.matchMedia('(max-width: 576px)').matches) {
                    sidebar.classList.remove('active');
                    mainContent.classList.remove('sidebar-active');
                    menuToggle.setAttribute('aria-expanded', 'false');
                }
            }

            menuToggle.addEventListener('click', toggleSidebar);
            closeSidebar.addEventListener('click', closeSidebarOnMobile);

            // Auto-close sidebar on navigation link click for mobile
            document.querySelectorAll('.sidebar a').forEach(link => {
                link.addEventListener('click', closeSidebarOnMobile);
            });

            // Modal functionality
            const viewIdBtn = document.querySelector('.view-id-btn');
            const idModal = document.querySelector('#idModal');
            const modalCloseBtn = document.querySelector('.modal .close-btn');

            viewIdBtn.addEventListener('click', function() {
                idModal.classList.add('show');
            });

            modalCloseBtn.addEventListener('click', function() {
                idModal.classList.remove('show');
            });

            // Close modal when clicking outside
            idModal.addEventListener('click', function(e) {
                if (e.target === idModal) {
                    idModal.classList.remove('show');
                }
            });

            // Close modal with Escape key
            document.addEventListener('keydown', function(e) {
                if (e.key === 'Escape') {
                    if (idModal.classList.contains('show')) {
                        idModal.classList.remove('show');
                    }
                    if (isMobile && sidebar.classList.contains('active')) {
                        closeSidebarOnMobile();
                    }
                }
            });

            // Prevent back button issues
            window.addEventListener('pageshow', function(event) {
                if (event.persisted || (window.performance && window.performance.navigation.type === 2)) {
                    window.location.reload();
                }
            });

            // Close sidebar on initial load for mobile
            if (isMobile) {
                closeSidebarOnMobile();
            }
        });