<?php
session_start();
include '../../database/db.php';

if (!isset($_SESSION['status_Account']) || $_SESSION['status_Account'] !== 'logged_in') {
    header("Location: ../../index.php");
    exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['appointment_id'])) {
    $appointment_id = intval($_POST['appointment_id']);
    $email = $_SESSION['email'];

    // Verify appointment belongs to logged-in user
    $stmt = $connection->prepare("DELETE FROM appointments WHERE appointment_id = ? AND email = ?");
    $stmt->bind_param("is", $appointment_id, $email);
    if ($stmt->execute()) {
        $_SESSION['message'] = "Appointment canceled successfully.";
    } else {
        $_SESSION['message'] = "Failed to cancel appointment.";
    }
    $stmt->close();
}

header("Location: appointment_table.php");
exit;
?>