<?php
session_start();
header("Cache-Control: no-cache, no-store, must-revalidate");
header("Pragma: no-cache");
header("Expires: 0");

if (!isset($_SESSION['status_Account']) || $_SESSION['status_Account'] !== 'logged_in') {
    header("Location: ../index.php");
    exit;
}

include '../database/db.php';

// Fetch all new (pending) appointments
$query = $connection->prepare("SELECT appointment_id, first_name, middle_name, last_name, purpose, created_at FROM appointments WHERE status = 'Pending' ORDER BY created_at DESC");
$query->execute();
$result = $query->get_result();
$newAppointments = $result->fetch_all(MYSQLI_ASSOC);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <meta http-equiv="Cache-Control" content="no-cache, no-store, must-revalidate" />
    <meta http-equiv="Pragma" content="no-cache" />
    <meta http-equiv="Expires" content="0" />
    <link href="https://unpkg.com/boxicons@2.1.4/css/boxicons.min.css" rel="stylesheet" />
    <link rel="icon" type="image/x-icon" href="../image/icons/logo1.ico" />
    <link rel="stylesheet" href="../css/style.css">
    <link rel="stylesheet" href="../css/notifications1.css">
    <title>Notifications - New Appointments</title>
</head>
<body>
    <div class="sidebar">
        <img src="../image/icons/logo1.ico" alt="Organization Logo" class="logo" />
            <button class="close-sidebar" aria-label="Close Sidebar">
                <i class='bx bx-x'></i>
            </button>
        <h2>Admin Dashboard</h2>
        <a href="./admin_dashboard.php">Home</a>
        <a href="./record.php">Record</a>
        <a href="./notifications.php" class="active">Notifications</a>
        <a href="../logout.php">Logout</a>
    </div>

<div class="main-content">
    <div class="dashboard-header">
        <button class="menu-toggle" aria-label="Toggle Sidebar" aria-expanded="false">
            <i class='bx bx-menu'></i>
        </button>
        <h1>New Appointment Requests</h1>
    </div>
        <div id="notification-list">
            <?php if (count($newAppointments) > 0): ?>
                <?php foreach ($newAppointments as $appt): ?>
                    <?php
                        $fullName = htmlspecialchars($appt['first_name'] . ' ' . $appt['middle_name'] . ' ' . $appt['last_name']);
                        $purpose = htmlspecialchars($appt['purpose']);
                        $dateTime = date("M d, Y H:i", strtotime($appt['created_at']));
                    ?>
                    <div class="notification">
                        <strong><?= $fullName ?></strong> requested <em><?= $purpose ?></em><br>
                        <small><?= $dateTime ?></small>
                    </div>
                <?php endforeach; ?>
            <?php else: ?>
                <p class="no-notifications">No new appointment requests.</p>
            <?php endif; ?>
        </div>
    </div>
<!--  JavaScript -->
<script src="../scripts/script_admin1.js"></script>
<script src="../scripts/notifications1.js"></script>
</body>
</html>
