<?php
session_start();
require_once('../database/db.php');
// Add composer autoloader
require_once __DIR__ . '/../vendor/autoload.php';
require_once('generate_excel.php');
if (!isset($_SESSION['status_Account']) || $_SESSION['status_Account'] !== 'logged_in') {
    die('Unauthorized access');
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $month = $_POST['reportMonth'];
    $type = $_POST['reportType'];
    $format = $_POST['format'];

    if ($format === 'excel') {
        generateExcelReport($month, $type);
    } else {
        // Your existing PDF generation code
        generatePDFReport($month, $type);
    }
}

function generatePDFReport($monthYear, $reportType) {
    global $connection; // Access the $connection variable from the global scope

    // Convert month-year to date range
    $startDate = date('Y-m-d', strtotime($monthYear . '-01'));
    $endDate = date('Y-m-t', strtotime($monthYear));

    // Build query based on report type
    $query = "SELECT * FROM appointments WHERE DATE(created_at) BETWEEN ? AND ?";
    if ($reportType !== 'all') {
        $query .= " AND status = ?";
    }
    $query .= " ORDER BY created_at DESC";

    // Prepare and execute query
    $stmt = $connection->prepare($query);
    if ($reportType !== 'all') {
        $stmt->bind_param("sss", $startDate, $endDate, $reportType);
    } else {
        $stmt->bind_param("ss", $startDate, $endDate);
    }
    $stmt->execute();
    $result = $stmt->get_result();

    try {
        // Initialize mPDF with explicit namespace
        $mpdf = new \Mpdf\Mpdf([
            'margin_left' => 15,
            'margin_right' => 15,
            'margin_top' => 15,
            'margin_bottom' => 15,
        ]);

        // Build HTML content
        $html = '
        <style>
            table { border-collapse: collapse; width: 100%; }
            th, td { border: 1px solid #ddd; padding: 8px; text-align: left; }
            th { background-color: #003087; color: white; }
            .header { text-align: center; margin-bottom: 20px; }
            .report-info { margin-bottom: 20px; }
        </style>
        <div class="header">
            <h1>Appointment Requests Report</h1>
            <h2>' . date('F Y', strtotime($monthYear)) . '</h2>
        </div>
        <div class="report-info">
            <p><strong>Status Filter:</strong> ' . htmlspecialchars($reportType) . '</p>
            <p><strong>Generated on:</strong> ' . date('F j, Y g:i A') . '</p>
        </div>
        ';

        if ($result->num_rows > 0) {
            $html .= '
            <table>
                <thead>
                    <tr>
                        <th>Client Name</th>
                        <th>Email</th>
                        <th>Date</th>
                        <th>Time</th>
                        <th>Status</th>
                        <th>Purpose</th>
                        <th>Remarks</th>
                    </tr>
                </thead>
                <tbody>';
            
            while ($row = $result->fetch_assoc()) {
                $html .= '<tr>
                    <td>' . htmlspecialchars($row['first_name'] . ' ' . $row['last_name']) . '</td>
                    <td>' . htmlspecialchars($row['email']) . '</td>
                    <td>' . date("F j, Y", strtotime($row['appointment_date'])) . '</td>
                    <td>' . date("g:i A", strtotime($row['appointment_time'])) . '</td>
                    <td>' . htmlspecialchars($row['status']) . '</td>
                    <td>' . htmlspecialchars($row['purpose']) . '</td>
                    <td>' . htmlspecialchars($row['remarks']) . '</td>
                </tr>';
            }
            
            $html .= '</tbody></table>';
        } else {
            $html .= '<p>No appointments found for the selected criteria.</p>';
        }

        // Generate PDF
        $mpdf->WriteHTML($html);
        $filename = 'Appointments_Report_' . date('F_Y', strtotime($monthYear)) . '.pdf';
        $mpdf->Output($filename, 'D');
    } catch (\Mpdf\MpdfException $e) {
        // Handle any mPDF specific errors
        die('Error creating PDF: ' . $e->getMessage());
    } catch (\Exception $e) {
        // Handle general errors
        die('General error: ' . $e->getMessage());
    }
}

