<?php
require_once '../vendor/autoload.php';
require_once '../database/db.php';

use setasign\Fpdi\Fpdi;

if (!isset($_GET['id'])) {
    die('No appointment ID provided.');
}

$appointment_id = intval($_GET['id']);

// Fetch appointment info
$stmt = $connection->prepare("SELECT * FROM appointments WHERE appointment_id = ?");
$stmt->bind_param("i", $appointment_id);
$stmt->execute();
$result = $stmt->get_result();
$data = $result->fetch_assoc();

if (!$data) {
    die('Appointment not found.');
}

// Generate or get control number
if (empty($data['control_number'])) {
    // Get current year and month
    $yearMonth = date('Ym');
    
    // Get the latest control number for this month
    $stmt = $connection->prepare("SELECT MAX(control_number) as max_num FROM appointments WHERE control_number LIKE ?");
    $pattern = $yearMonth . '-%';
    $stmt->bind_param("s", $pattern);
    $stmt->execute();
    $result = $stmt->get_result();
    $row = $result->fetch_assoc();
    
    // Generate new number
    if ($row['max_num']) {
        $lastNum = intval(substr($row['max_num'], -3));
        $newNum = str_pad($lastNum + 1, 3, '0', STR_PAD_LEFT);
    } else {
        $newNum = '001';
    }
    
    // Create new control number
    $controlNumber = $yearMonth . '-' . $newNum;
    
    // Update the appointment with the new control number
    $stmt = $connection->prepare("UPDATE appointments SET control_number = ? WHERE appointment_id = ?");
    $stmt->bind_param("si", $controlNumber, $appointment_id);
    $stmt->execute();
} else {
    $controlNumber = $data['control_number'];
}

// Start PDF
$pdf = new Fpdi();

// Get the page count of the source file
$pageCount = $pdf->setSourceFile('../Templates/LOI & APPLICATION FORM.pdf');

// Only loop through first 2 pages
for ($pageNo = 1; $pageNo <= 2; $pageNo++) {
    // Add a page
    $pdf->AddPage();
    // Import the page
    $tplIdx = $pdf->importPage($pageNo);
    // Use the imported page
    $pdf->useTemplate($tplIdx, 0, 0, 210);
    
    // Only add form data on the first page
    if ($pageNo === 1) {
        // Add profile photo if it exists
        if (!empty($data['profile_photo'])) {
            // Define exact dimensions in millimeters
            $photoWidth = 35;  // 3.5 cm = 35 mm
            $photoHeight = 45; // 4.5 cm = 45 mm
            
            // Use the full path from database
            $photoPath = $data['profile_photo'];
            
            // Check if file exists using the full path
            if (file_exists($photoPath)) {
                // Add image to PDF with exact dimensions
                $pdf->Image($photoPath, 165, 25, $photoWidth, $photoHeight);
            }
        }

        // Rest of your existing page 1 code
        $pdf->SetFont('Times', '', 12);
        $pdf->SetTextColor(0,0,0);

        //Coordinates (adjust as needed)
        $pdf->SetXY(40, 90);
        $pdf->Cell(0, 10, $data['first_name'] . ' ' . $data['last_name'], 0, 1);

        // Add gender checkmarks
        $pdf->SetFont('ZapfDingbats', '', 12); // Special font for checkmark symbol
        if ($data['gender'] === 'Male') {
            $pdf->SetXY(155, 257); // Adjust these coordinates to match male checkbox position
            $pdf->Cell(0, 10, '4', 0, 1); // '4' is the checkmark symbol in ZapfDingbats font
        } else if ($data['gender'] === 'Female') {
            $pdf->SetXY(175, 257); // Adjust these coordinates to match female checkbox position
            $pdf->Cell(0, 10, '4', 0, 1);
        }
        
        $pdf->SetFont('Times', '', 12);

        $pdf->SetXY(177, 10);
        $pdf->Cell(0, 10, $controlNumber, 0, 1);

        $pdf->SetXY(130, 250);
        $pdf->Cell(0, 10, $data['email'], 0, 1);

        $pdf->SetXY(60, 250);
        $pdf->Cell(0, 10, '+63' . $data['contact'], 0, 1);

        $pdf->SetXY(165, 70);
        $pdf->Cell(0, 10, $data['appointment_date'], 0, 1);

        $pdf->SetXY(30, 96);
        $pdf->Cell(0, 10, $data['address'], 0, 1);
    }
    
    // Add ID information on the second page
    if ($pageNo === 2) {
        $pdf->SetFont('Times', '', 12);
        $pdf->SetTextColor(0,0,0);

        $pdf->SetXY(177, 10);
        $pdf->Cell(0, 10, $controlNumber, 0, 1);

        $pdf->SetXY(145, 184);
        $pdf->Cell(0, 10, $data['first_name'] . ' ' . $data['last_name'], 0, 1);

        // Adjust font size for ID Type based on length
        $idTypeLength = strlen($data['id_type']);
        if ($idTypeLength > 20) {
            $pdf->SetFont('Times', '', 8); // Smaller font for long text
        } else {
            $pdf->SetFont('Times', '', 12); // Normal font for short text
        }
        
        // Add ID Type with MultiCell for line wrapping
        $pdf->SetXY(70, 221);
        $pdf->MultiCell(40, 10, $data['id_type'], 0, 'L');
        
        // Reset font size for ID Number
        $pdf->SetFont('Times', '', 12);
        $pdf->SetXY(25, 225);
        $pdf->Cell(0, 10, $data['id_number'], 0, 1);
    }
}

// Output PDF
$pdf->Output('D', 'LOI_Application_Form_' . $data['last_name'] . '.pdf');
exit;